/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurationUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationUtils.class);
    private static boolean customSource;
    private static final String PUBLIC = ".public";
    public static final String CONFIG_FILE = "ehking-config.properties";

    private static String getString(String key) {
        String value = StringUtils.trim((String)Holder.config.getString(key));
        if (StringUtils.isBlank((CharSequence)value)) {
            LOGGER.warn("ConfigurationUtils.getString:[" + key + "] is blank");
        }
        return value;
    }

    private static Integer getInteger(String key, Integer defaultValue) {
        Integer value = Holder.config.getInteger(key, defaultValue);
        return value;
    }

    public static String getPublicKey(String merchantId) {
        return ConfigurationUtils.getString(merchantId + PUBLIC);
    }

    public static String getHmacKey(String merchantId) {
        return ConfigurationUtils.getString(merchantId);
    }

    public static Integer getConnectTimeout() {
        return ConfigurationUtils.getInteger("ehking.sdk.net.client.defaultConnectTimeout", null);
    }

    public static Integer getReadTimeout() {
        return ConfigurationUtils.getInteger("ehking.sdk.net.client.defaultReadTimeout", null);
    }

    public static String getHttpContentType() {
        return ConfigurationUtils.getString("http.content.type");
    }

    public static String getHttpContentTypeV2() {
        return ConfigurationUtils.getString("http.content.type.v2");
    }

    public static String getHttpContentTypeV3() {
        return ConfigurationUtils.getString("http.content.type.v3");
    }

    public static String getServerPublicKey() {
        return ConfigurationUtils.getString("server.public.key.path");
    }

    public static String getClientPrivateKeyPath(String merchantId) {
        return ConfigurationUtils.getString(merchantId + ".client.private.key.path");
    }

    public static String getClientPrivateKeyPassword(String merchantId) {
        return ConfigurationUtils.getString(merchantId + ".client.private.key.password");
    }

    public static void setProperty(String key, Object value) {
        Holder.config.setProperty(key, value);
    }

    public static void setConfigSource(Configuration configSource) {
        if (configSource == null) {
            throw new IllegalArgumentException("configSource is null");
        }
        customSource = true;
        Holder.config = configSource;
    }

    public static String getOldClientPrivateKeyPath(String merchantId) {
        return ConfigurationUtils.getString(merchantId + ".client.old.private.key.path");
    }

    public static String getOldClientPrivateKeyPassword(String merchantId) {
        return ConfigurationUtils.getString(merchantId + ".client.old.private.key.password");
    }

    public static String getCpOnlinePayOrderUrl() {
        return ConfigurationUtils.getString("cp.onlinepay.order.url");
    }

    public static String getCpOnlinePayQueryUrl() {
        return ConfigurationUtils.getString("cp.onlinepay.query.url");
    }

    public static String getCpOnlinePayRefundUrl() {
        return ConfigurationUtils.getString("cp.onlinepay.refund.url");
    }

    public static String getCpOnlinePayRefundQueryUrl() {
        return ConfigurationUtils.getString("cp.onlinepay.refund.query.url");
    }

    public static String getCpOnlinePayCloseOrderUrl() {
        return ConfigurationUtils.getString("cp.onlinepay.close.order.url");
    }

    public static String getOverseasListPriceUrl() {
        return ConfigurationUtils.getString("overseas.bid.url");
    }

    public static String getOverseasAccountQueryUrl() {
        return ConfigurationUtils.getString("overseas.account.query.url");
    }

    public static String getOverseasAccountBalanceQueryUrl() {
        return ConfigurationUtils.getString("overseas.account.balance.query.url");
    }

    public static String getRemittanceOrderUrl() {
        return ConfigurationUtils.getString("remittance.order.url");
    }

    public static String getRemittanceQueryUrl() {
        return ConfigurationUtils.getString("remittance.query.url");
    }

    public static String getRemittanceCancelUrl() {
        return ConfigurationUtils.getString("remittance.cancel.url");
    }

    public static String getAuthServerSignPublicKey() {
        return ConfigurationUtils.getString("orz.auth.server.sign.public.key.path");
    }

    public static String getAuthServerContentPublicKey() {
        return ConfigurationUtils.getString("orz.auth.server.content.public.key.path");
    }

    public static String getOrzAuthOrderUrl() {
        return ConfigurationUtils.getString("orz.auth.order.url");
    }

    public static String getOrzAuthQueryUrl() {
        return ConfigurationUtils.getString("orz.auth.query.url");
    }

    public static String getRemittanceTransferServerPublicKey() {
        return ConfigurationUtils.getString("remittance.transfer.server.public.key.path");
    }

    public static String getRemittanceTransferServerPublicKeyKid() {
        return ConfigurationUtils.getString("remittance.transfer.server.public.key.kid");
    }

    public static String getRemittanceTransferPrivateKey(String merchantId) {
        return ConfigurationUtils.getString("remittance.transfer.client.private.key.path");
    }

    public static String getRemittanceTransferPrivateKid() {
        return ConfigurationUtils.getString("remittance.transfer.client.private.key.kid");
    }

    public static String getRemittanceTransferPrivateKeyPassword(String merchantId) {
        return ConfigurationUtils.getString("remittance.transfer.client.private.key.password");
    }

    public static String getRemittanceTransferIin() {
        return ConfigurationUtils.getString("remittance.transfer.iin");
    }

    public static String getRemittanceTransferAccountConfirmUrl() {
        return ConfigurationUtils.getString("remittance.transfer.accountconfirm.url");
    }

    public static String getRemittanceTransferOrderUrl() {
        return ConfigurationUtils.getString("remittance.transfer.order.url");
    }

    public static String getRemittanceTransferQueryUrl() {
        return ConfigurationUtils.getString("remittance.transfer.query.url");
    }

    public static String getInspectUploadUrl() {
        return ConfigurationUtils.getString("inspect.upload.url");
    }

    public static String getInspectUploadQueryUrl() {
        return ConfigurationUtils.getString("inspect.upload.query.url");
    }

    public static String getFrCreateQuotationUrl() {
        return ConfigurationUtils.getString("fr.create.quotation.url");
    }

    public static String getFrQueryQuotationUrl() {
        return ConfigurationUtils.getString("fr.query.quotation.url");
    }

    public static String getFrCreateRemitOrderUrl() {
        return ConfigurationUtils.getString("fr.create.remit.order.url");
    }

    public static String getFrQueryRemitOrderUrl() {
        return ConfigurationUtils.getString("fr.query.remit.order.url");
    }

    public static String getFrQueryListPriceUrl() {
        return ConfigurationUtils.getString("fr.query.list.price.url");
    }

    public static String getFrCancelRemitOrderUrl() {
        return ConfigurationUtils.getString("fr.cancel.remit.order.url");
    }

    public static String getFrCreatePayeeUrl() {
        return ConfigurationUtils.getString("fr.create.payee.url");
    }

    public static String getFrQueryPayeeUrl() {
        return ConfigurationUtils.getString("fr.query.payee.url");
    }

    public static String getRemittancePayer2PayeeCreateUrl() {
        return ConfigurationUtils.getString("remittance.payer2payee.create.url");
    }

    public static String getRemittancePayer2PayeeQueryUrl() {
        return ConfigurationUtils.getString("remittance.payer2payee.query.url");
    }

    public static String getRemittanceCardBinVerifyUrl() {
        return ConfigurationUtils.getString("remittance.cardBin.verify.url");
    }

    public static String getOfflineInspectUploadUrl() {
        return ConfigurationUtils.getString("inspect.overseas.offline.upload.url");
    }

    public static String getOfflineInspectUploadQueryUrl() {
        return ConfigurationUtils.getString("inspect.overseas.offline.upload.query.url");
    }

    public static String getRemittanceVoucherCreateUrl() {
        return ConfigurationUtils.getString("remittance.voucher.create.url");
    }

    public static String getVaDeclarationOrderUrl() {
        return ConfigurationUtils.getString("va.declaration.order.url");
    }

    public static String getVaDeclarationQueryUrl() {
        return ConfigurationUtils.getString("va.declaration.query.url");
    }

    public static String getVaOrderProofUrl() {
        return ConfigurationUtils.getString("va.order.proof.url");
    }

    public static String getVaCreateAccountUrl() {
        return ConfigurationUtils.getString("va.account.create.url");
    }

    public static String getVaQueryAccountUrl() {
        return ConfigurationUtils.getString("va.account.query.url");
    }

    public static String getVaDeleteAccountUrl() {
        return ConfigurationUtils.getString("va.account.delete.url");
    }

    public static String getVaUploadFeeUrl() {
        return ConfigurationUtils.getString("va.profile.upload.fee.url");
    }

    public static String getFxCreateQuotationUrl() {
        return ConfigurationUtils.getString("fx.create.quotation.url");
    }

    public static String getFxCreateOrderUrl() {
        return ConfigurationUtils.getString("fx.create.order.url");
    }

    public static String getFxQueryOrderUrl() {
        return ConfigurationUtils.getString("fx.query.order.url");
    }

    private static class Holder {
        public static Configuration config;

        private Holder() {
        }

        static {
            try {
                if (!customSource) {
                    config = new PropertiesConfiguration(ConfigurationUtils.CONFIG_FILE);
                }
            }
            catch (ConfigurationException e) {
                LOGGER.error("classpath:ehking-config.properties not found", (Throwable)e);
            }
        }
    }
}

