/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk;

import com.ehking.sdk.CommonConfigUtils;
import com.ehking.sdk.ConfigFileAlterationListener;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.PrepayConfigurationUtils;
import java.io.File;
import java.util.Iterator;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileListener
implements ConfigFileAlterationListener {
    static final Logger LOGGER = LoggerFactory.getLogger(ConfigFileListener.class);

    @Override
    public ConfigFileAlterationListener init(String filePath) {
        LOGGER.info("ConfigFileListener#init ...filePath:{}", (Object)filePath);
        try {
            File fileDir = new File(filePath);
            if (fileDir.isDirectory()) {
                File[] configFiles;
                for (File configFile : configFiles = fileDir.listFiles()) {
                    this.loadConfigFile(configFile);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("ConfigFileListener#init fail", (Throwable)e);
        }
        return this;
    }

    public void onStart(FileAlterationObserver fileAlterationObserver) {
    }

    public void onDirectoryCreate(File file) {
        LOGGER.info("ConfigFileListener#onDirectoryCreate  ...NOT SUPPORT");
    }

    public void onDirectoryChange(File file) {
        LOGGER.info("ConfigFileListener#onDirectoryChange  ...NOT SUPPORT");
    }

    public void onDirectoryDelete(File file) {
        LOGGER.info("ConfigFileListener#onDirectoryDelete  ...NOT SUPPORT");
    }

    public void onFileCreate(File file) {
        LOGGER.info("ConfigFileListener#onFileCreate ...");
        this.loadConfigFile(file);
    }

    public void onFileChange(File file) {
        LOGGER.info("ConfigFileListener#onFileChange ...");
        this.loadConfigFile(file);
    }

    public void onFileDelete(File file) {
        LOGGER.info("ConfigFileListener#onFileDelete ...NOT SUPPORT");
    }

    public void onStop(FileAlterationObserver fileAlterationObserver) {
    }

    private void loadConfigFile(File configFile) {
        try {
            LOGGER.info("-------------load------------{}--------start-------------------", (Object)configFile.getName());
            if (!CommonConfigUtils.get("ehking.config.properties").equals(configFile.getName()) && !CommonConfigUtils.get("prepay.config.properties").equals(configFile.getName())) {
                LOGGER.info("---------------NOT SUPPORT THIS FILE");
                return;
            }
            PropertiesConfiguration config = new PropertiesConfiguration(configFile);
            Iterator iter = config.getKeys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                LOGGER.info(" key:{}", (Object)key);
                if (CommonConfigUtils.get("ehking.config.properties").equals(configFile.getName())) {
                    ConfigurationUtils.setProperty(key, config.getString(key));
                    continue;
                }
                if (!CommonConfigUtils.get("prepay.config.properties").equals(configFile.getName())) continue;
                PrepayConfigurationUtils.setProperty(key, config.getString(key));
            }
            LOGGER.info("--------------load-----------{}-----------end----------------", (Object)configFile.getName());
        }
        catch (Exception e) {
            LOGGER.error("ConfigFileListener#loadConfigFile  load file " + configFile.getName() + " fail...", (Throwable)e);
        }
    }
}

