package utils

import (
	"fmt"
	"time"
)

// Notify 处理异步通知：输入为 http headers（map[string]string）和 http body（map[string]interface{}）
// 返回解密并验签后的明文 map
func Notify(httpHeader map[string]string, httpBody map[string]string) (string, error) {
	// 1. 获取商户配置（优先 partnerId, 否则 merchantId）
	id := ""
	if v, ok := httpHeader["partnerId"]; ok && v != "" {
		id = v
	} else if v, ok := httpHeader["merchantId"]; ok && v != "" {
		id = v
	} else {
		return "", fmt.Errorf("notify header missing merchantId and partnerId")
	}

	conf, err := LoadConfig()
	if err != nil {
		panic(err)
	}

	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"HTTP Content Type:", conf.HTTPContentTypeV3)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"Server Public Key:", conf.ServerPublicKey)

	clientKey, ok := GetClientKey(id)
	if ok {
		fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"Client Path:", clientKey.Path)
		fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"Client Password:", clientKey.Password)
	}

	encKeyHeader := httpHeader["encryptKey"]
	if encKeyHeader == "" {
		return "", fmt.Errorf("notify header missing encryptKey")
	}

	// 2. 私钥解密 encryptKey -> aesKey
	aesKey, err := PrivateDecrypt(encKeyHeader, clientKey.Path, clientKey.Password)
	if err != nil {
		return "", err
	}

	// 3. 解密 body.data
	dataVal, ok := httpBody["data"]
	if !ok {
		return "", fmt.Errorf("notify body.data missing or not string")
	}
	respJsonString, err := AesECBDecrypt(dataVal, aesKey)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"解密后通知报文respJsonString: ", respJsonString)
	if err != nil {
		return "", err
	}

	status, err := JsonGetValue(respJsonString, "status")
	if err != nil {
		return "", err
	}

	if status == "ERROR" {
		// 如果 status = ERROR，直接返回（无需验签）
		return respJsonString, nil
	}

	hmac, err := JsonGetValue(respJsonString, "hmac")
	if err != nil {
		return "", err
	}
	respJsonStringWithNoHmac, err := JsonDelField(respJsonString, "hmac")
	if err != nil {
		return "", err
	}

	sortedJson, err := JsonGetSortString(respJsonStringWithNoHmac)
	if err != nil {
		return "", err
	}
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"异步通知json报文排序后字符串:", sortedJson)

	degistHex := Sha1(sortedJson)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"请求报文摘要degistHex: ", degistHex)

	// 4. 验签：取出 hmac 字段，删除后对剩余字段排序并 SHA1 摘要
	err = VerifySign(degistHex, conf.ServerPublicKey, hmac)

	if err != nil {
		return "", fmt.Errorf("verify signature failed: %v", err)
	} else {
		fmt.Println("[" + time.Now().Format("2006-01-02 15:04:05.000") + "] " + "verify signature success")
		return respJsonString, nil
	}
}
