package utils

import (
	"encoding/json"
	"fmt"
	"os"
	"sync"
)

// 客户端私钥信息
type ClientKey struct {
	Path     string `json:"path"`
	Password string `json:"password"`
}

// 配置结构体
type Config struct {
	HTTPContentTypeV3 string               `json:"http.content.type.v3"`
	ServerPublicKey   string               `json:"server.public.key.path"`
	Clients           map[string]ClientKey `json:"clients"` // key 是商户号
}

var (
	Conf *Config
	once sync.Once
)

// LoadConfig 加载配置文件
func LoadConfig() (*Config, error) {
	var err error
	var configFile = "./config.json"
	once.Do(func() {
		file, e := os.Open(configFile)
		if e != nil {
			err = fmt.Errorf("failed to open config file: %v", e)
			return
		}
		defer file.Close()

		decoder := json.NewDecoder(file)
		cfg := &Config{}
		if e := decoder.Decode(cfg); e != nil {
			err = fmt.Errorf("failed to decode config json: %v", e)
			return
		}

		Conf = cfg
	})
	return Conf, err
}

// 获取指定商户的私钥信息
func GetClientKey(clientID string) (ClientKey, bool) {
	if Conf == nil {
		return ClientKey{}, false
	}
	key, ok := Conf.Clients[clientID]
	return key, ok
}
