package utils

import (
	"bytes"
	"encoding/json"
	"fmt"
	"io"
	"net/http"
	"time"
)

// 导入配置文件

func CallApi(partnerId, merchantId, url string, requestData string) (string, error) {
	fmt.Println("[" + time.Now().Format("2006-01-02 15:04:05.000") + "] " + "CallApi start...")
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"url:", url)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"partnerId:", partnerId)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"merchantId:", merchantId)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"requestData:", requestData)

	var id string
	if partnerId != "" {
		id = partnerId
	} else if merchantId != "" {
		id = merchantId
	} else {
		return "", fmt.Errorf("partnerId and merchantId cannot both be empty")
	}

	conf, err := LoadConfig()
	if err != nil {
		panic(err)
	}

	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"HTTP Content Type:", conf.HTTPContentTypeV3)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"Server Public Key:", conf.ServerPublicKey)

	clientKey, ok := GetClientKey(id)
	if ok {
		fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"Client Path:", clientKey.Path)
		fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"Client Password:", clientKey.Password)
	}

	// 1. 排序生成摘要
	sortdata, oerr := JsonGetSortString(requestData)
	if oerr != nil {
		fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"oerr:", oerr)
	}
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"request sortdata: ", sortdata)

	//hamc
	degistHex := Sha1(sortdata)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"请求报文摘要degistHex: ", degistHex)

	hmac, err := Sign(degistHex, clientKey.Path, clientKey.Password)
	if err != nil {
		fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"Sign err:", err)
	}
	requestData, err = JsonAddField(requestData, "hmac", hmac)
	if err != nil {
		fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"AddJsonField err:", err)
	}

	// 3. 生成 AES key
	var aesKey string = GenerateRandomString(16)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"aesKey: ", aesKey)

	// 4. AES 加密请求数据
	fmt.Println("[" + time.Now().Format("2006-01-02 15:04:05.000") + "] " + "AES 加密... ")
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"aesKey: ", aesKey)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"requestData: ", requestData)

	encryptedData, err := AesECBEncrypt(requestData, aesKey)

	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"encryptedData: ", encryptedData)

	if err != nil {
		fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"AesECBEncrypt err: ", err)
	}

	// 5. 加密 AES key
	fmt.Println("[" + time.Now().Format("2006-01-02 15:04:05.000") + "] " + "加密 AES key... ")
	encryptedKey, err := PublicEncrypt(aesKey, conf.ServerPublicKey)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"encryptedKey: ", encryptedKey)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"err: ", err)
	if err != nil {
		fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"PublicEncrypt err: ", err)
	}

	requestId, err := JsonGetValue(requestData, "requestId")
	if err != nil {
		fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"GetJsonValue err: ", err)
	}

	// 6. HTTP POST
	headers := map[string]string{
		"Content-Type": conf.HTTPContentTypeV3,
		"merchantId":   merchantId,
		"requestId":    requestId,
		"encryptKey":   encryptedKey,
	}
	if partnerId != "" {
		headers["partnerId"] = partnerId
	}

	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"ApiUrl: ", url)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"headers: ", headers)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"encryptedData: ", encryptedData)
	res, err := httpPost(url, encryptedData, headers)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"接口应答报文: ", string(res.Body))
	if err != nil {
		return "", err
	}

	// 7. 解析响应体
	var respBody map[string]interface{}
	if err := json.Unmarshal([]byte(res.Body), &respBody); err != nil {
		return "", err
	}

	if respBody["status"] == "ERROR" {
		return string(res.Body), nil
	}

	// 8. 解密返回 AES key
	returnedKey, err := PrivateDecrypt(res.EncryptKey, clientKey.Path, clientKey.Password)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"EncryptKey: ", returnedKey)

	if err != nil {
		return "", err
	}

	// 9. 解密 data
	decryptedData, err := AesECBDecrypt(respBody["data"].(string), returnedKey)
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"decryptedData: ", decryptedData)
	if err != nil {
		return "", err
	}

	//解密和后数据，如果status == "ERROR" 直接返回错误信息
	if status, err := JsonGetValue(decryptedData, "status"); err == nil && status == "ERROR" {
		return decryptedData, nil
	}

	hmac, err = JsonGetValue(decryptedData, "hmac")
	respJsonStringWithNoHmac, err := JsonDelField(decryptedData, "hmac")
	sortedJson, err := JsonGetSortString(respJsonStringWithNoHmac)

	if err != nil {
		return "", err
	}
	fmt.Println("["+time.Now().Format("2006-01-02 15:04:05.000")+"] "+"同步返回报json报文排序后字符串:", sortedJson)
	degistHex = Sha1(sortedJson)
	// 验签: 取出 hmac 字段，删除后对剩余字段排序并 SHA1 摘要
	err = VerifySign(degistHex, conf.ServerPublicKey, hmac)

	// 10. 验签
	err = VerifySign(degistHex, conf.ServerPublicKey, hmac)
	if err != nil {
		return "", fmt.Errorf("verify signature failed: %v", err)
	} else {
		fmt.Println("[" + time.Now().Format("2006-01-02 15:04:05.000") + "] " + "verify signature success")
		return decryptedData, nil
	}
}

// --- 内部函数 ---
type HttpResponse struct {
	Body       []byte
	EncryptKey string
}

func httpPost(url string, data string, headers map[string]string) (*HttpResponse, error) {
	req, _ := http.NewRequest("POST", url, bytes.NewBuffer([]byte(data)))
	for k, v := range headers {
		req.Header.Set(k, v)
	}
	client := &http.Client{}
	resp, err := client.Do(req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	body, _ := io.ReadAll(resp.Body)
	return &HttpResponse{
		Body:       body,
		EncryptKey: resp.Header.Get("encryptKey"),
	}, nil
}
