package utils

import (
	"math/rand"
	"strings"
)

// GenerateRandomString 生成指定长度的随机字符串（大小写字母 + 数字）
// length: 期望字符串长度，例如 16
func GenerateRandomString(length int) string {
	const charset = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789"
	var sb strings.Builder
	sb.Grow(length)

	for i := 0; i < length; i++ {
		sb.WriteByte(charset[rand.Intn(len(charset))])
	}
	return sb.String()
}
