package utils

import (
	"fmt"
	"regexp"
	"sort"
	"strings"
	"time"

	//"reflect"
	"encoding/json"
	"math/rand"
	"strconv"
)

// 随机生成指定位数的大写字母和数字的组合
func GetRandomString(l int) string {
	str := "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
	bytes := []byte(str)
	result := []byte{}
	r := rand.New(rand.NewSource(time.Now().UnixNano()))
	for i := 0; i < l; i++ {
		result = append(result, bytes[r.Intn(len(bytes))])
	}
	return string(result)
}

// 根据JSON字符串返回以键值存在的数组
func getMapFromJson(jsonstr string) map[string]interface{} {
	var jsonBody = []byte(jsonstr)
	var dat map[string]interface{}
	if err := json.Unmarshal(jsonBody, &dat); err == nil {
		return dat
	} else {
		return nil
	}
}

// 根据JSON字符串进行排序后返回顺序拼接字符串
func JsonGetSortString(jsonstr string) (string, error) {
	map2 := getMapFromJson(jsonstr)
	var recResult string
	var erro error
	//1.定义一个slice
	s1 := make([]string, 0, len(map2))
	//2.遍历map获取key-->s1中
	for key := range map2 {
		s1 = append(s1, key)
	}
	//3.给s1进行排序
	//使用sort包下的方法直接排序，不用自己写冒泡了。
	sort.Strings(s1)
	//4. 遍历s1，map
	for _, k := range s1 { // 先下标，再数值
		switch value := map2[k].(type) {
		case nil:
			fmt.Println(k, "is nil", "null")
		case int:
			recResult = recResult + strconv.Itoa(value) + "#"
		case float64:
			recResult = recResult + strconv.FormatFloat(value, 'f', -1, 64) + "#"
		case string:
			if value != "" {
				recResult = recResult + value + "#"
			}
		case bool:
			recResult = recResult + strconv.FormatBool(value) + "#"
		case []interface{}:
			for _, u := range value {
				//fmt.Println("utype:", reflect.TypeOf(u))
				if _, ok := u.(map[string]interface{}); ok != true {
					recResult = recResult + u.(string) + "#"
				} else {
					b, berror := json.Marshal(u)
					if berror != nil {
						erro = berror
					}
					rec, erro2 := JsonGetSortString(string(b))
					if erro2 != nil {
						erro = erro2
					}
					recResult = recResult + rec
				}
			}
		case map[string]interface{}:
			b, berror := json.Marshal(value)
			if berror != nil {
				fmt.Print("berror:", berror)
			}
			rec, erro2 := JsonGetSortString(string(b))
			if erro2 != nil {
				erro = erro2
			}
			recResult = recResult + rec
		default:
			va := value.(string)
			if va != "" {
				recResult = recResult + va + "#"
			}
		}
	}
	return recResult, erro
}

// 读取测试数据的文件内容
func IsNull(arr []string) string {
	if len(arr) != 0 {
		return arr[0]
	} else {
		return "error"
	}
}

// JsonAddField 增加 JSON 中的某个字段，如果key已存在原值将被覆盖
func JsonAddField(jsonStr, key, value string) (string, error) {
	var data map[string]interface{}

	// 解析 JSON 字符串
	if err := json.Unmarshal([]byte(jsonStr), &data); err != nil {
		return "", fmt.Errorf("解析 JSON 失败: %v", err)
	}

	// 增加或修改字段
	data[key] = value

	// 转回字符串
	bytes, err := json.Marshal(data)
	if err != nil {
		return "", fmt.Errorf("生成 JSON 失败: %v", err)
	}

	return string(bytes), nil
}

// DeleteJSONField 删除 JSON 中的某个字段
func JsonDelField(jsonStr, key string) (string, error) {
	var data map[string]interface{}

	// 解析 JSON
	if err := json.Unmarshal([]byte(jsonStr), &data); err != nil {
		return "", fmt.Errorf("解析 JSON 失败: %v", err)
	}

	// 删除字段
	delete(data, key)

	// 转回字符串
	bytes, err := json.Marshal(data)
	if err != nil {
		return "", fmt.Errorf("生成 JSON 失败: %v", err)
	}

	return string(bytes), nil
}

// GetJsonValue 从 JSON 字符串中根据路径（支持多层、数组）获取值
// 例如 keyPath: "user[0].address.city"
func JsonGetValue(jsonString, keyPath string) (string, error) {
	var data interface{}
	if err := json.Unmarshal([]byte(jsonString), &data); err != nil {
		return "", fmt.Errorf("invalid json: %v", err)
	}

	keys := strings.Split(keyPath, ".")
	reArray := regexp.MustCompile(`^([a-zA-Z0-9_]+)$begin:math:display$(\\d+)$end:math:display$$`)
	current := data

	for _, k := range keys {
		if matches := reArray.FindStringSubmatch(k); len(matches) == 3 {
			field := matches[1]
			index, _ := strconv.Atoi(matches[2])
			m, ok := current.(map[string]interface{})
			if !ok {
				return "", nil
			}
			arrVal, exists := m[field]
			if !exists {
				return "", nil
			}
			arr, ok := arrVal.([]interface{})
			if !ok || index >= len(arr) {
				return "", nil
			}
			current = arr[index]
		} else {
			m, ok := current.(map[string]interface{})
			if !ok {
				return "", nil
			}
			v, exists := m[k]
			if !exists {
				return "", nil
			}
			current = v
		}
	}

	switch val := current.(type) {
	case string:
		return val, nil
	case float64:
		return fmt.Sprintf("%v", val), nil
	case bool:
		return fmt.Sprintf("%v", val), nil
	default:
		bytes, _ := json.Marshal(val)
		return string(bytes), nil
	}
}
