package main

import (
	"encoding/json"
	"fmt"
	"geoswift-sdk-go/utils"
)

func main() {
	url := "https://qa-api.geoswift.com/fx/order/query"
	merchantId := "G90008001"
	requestId := "20251030165603"

	requestDataMap := map[string]string{
		"merchantId": merchantId,
		"requestId":  requestId,
	}
	requestData, err := json.Marshal(requestDataMap)

	result, err := utils.CallApi("", merchantId, url, string(requestData))
	if err != nil {
		fmt.Println("error:", err)
		return
	}

	fmt.Println("接口返回明文:", result)
	fmt.Println("结束")
}
